/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.transformer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.terraforged.mod.featuremanager.FeatureSerializer;
import com.terraforged.mod.featuremanager.transformer.FeatureAppender;
import com.terraforged.mod.featuremanager.transformer.FeatureInjector;
import com.terraforged.mod.featuremanager.transformer.FeatureReplacer;
import com.terraforged.mod.featuremanager.transformer.FeatureTransformer;
import com.terraforged.mod.featuremanager.transformer.InjectionPosition;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class FeatureParser {
    public static Optional<FeatureReplacer> parseReplacer(JsonObject root) {
        if (root.has("replace")) {
            return FeatureSerializer.deserialize(root.get("replace")).map(FeatureReplacer::of);
        }
        return Optional.empty();
    }

    public static Optional<FeatureInjector> parseInjector(JsonObject root) {
        if (root.has(InjectionPosition.BEFORE.getName())) {
            return FeatureSerializer.deserialize(root.get(InjectionPosition.BEFORE.getName())).map(feature -> new FeatureInjector((ConfiguredFeature<?, ?>)feature, InjectionPosition.BEFORE));
        }
        if (root.has(InjectionPosition.AFTER.getName())) {
            return FeatureSerializer.deserialize(root.get(InjectionPosition.AFTER.getName())).map(feature -> new FeatureInjector((ConfiguredFeature<?, ?>)feature, InjectionPosition.AFTER));
        }
        return Optional.empty();
    }

    public static Optional<FeatureAppender> parseAppender(JsonObject root) {
        if (root.has("stage")) {
            GenerationStage.Decoration stage = GenerationStage.Decoration.valueOf((String)root.get("stage").getAsString());
            if (root.has(InjectionPosition.HEAD.getName())) {
                return FeatureSerializer.deserialize(root.get(InjectionPosition.HEAD.getName())).map(feature -> new FeatureAppender((ConfiguredFeature<?, ?>)feature, InjectionPosition.HEAD, stage));
            }
            if (root.has(InjectionPosition.TAIL.getName())) {
                return FeatureSerializer.deserialize(root.get(InjectionPosition.TAIL.getName())).map(feature -> new FeatureAppender((ConfiguredFeature<?, ?>)feature, InjectionPosition.TAIL, stage));
            }
        }
        return Optional.empty();
    }

    public static Optional<FeatureTransformer> parseTransformer(JsonObject root) {
        if (root.has("transform")) {
            return FeatureParser.parseTransform(root.get("transform"));
        }
        return Optional.empty();
    }

    private static Optional<FeatureTransformer> parseTransform(JsonElement element) {
        if (!element.isJsonObject()) {
            return Optional.empty();
        }
        FeatureTransformer.Builder builder = FeatureTransformer.builder();
        for (Map.Entry e : element.getAsJsonObject().entrySet()) {
            if (((JsonElement)e.getValue()).isJsonPrimitive()) {
                JsonPrimitive key = FeatureParser.keyToPrimitive((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonPrimitive());
                if (key != null) {
                    builder.value(key, ((JsonElement)e.getValue()).getAsJsonPrimitive());
                    continue;
                }
                builder.key((String)e.getKey(), (JsonElement)e.getValue());
                continue;
            }
            builder.key((String)e.getKey(), (JsonElement)e.getValue());
        }
        return Optional.of(builder.build());
    }

    private static JsonPrimitive keyToPrimitive(String key, JsonPrimitive value) {
        if (value.isString()) {
            return new JsonPrimitive(key);
        }
        if (value.isNumber()) {
            try {
                Double.parseDouble(key);
                return new JsonPrimitive(new JsonPrimitive(key).getAsNumber());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (value.isBoolean() && (key.equalsIgnoreCase("true") || key.equalsIgnoreCase("false"))) {
            return new JsonPrimitive(Boolean.valueOf(new JsonPrimitive(key).getAsBoolean()));
        }
        return null;
    }
}

